#include <vo_stdio.h>
#include <string.h>
#include <vo_gpio.h>
#include <vs1010c.h>

#include "src/I2C/i2c.h"

void I2CStart();
void I2CStop();
void i2c_write8( u_int16 address, u_int16 reg,  u_int16 value);

u_int16 i2c_read8(register u_int16 address, register u_int16 reg);
u_int16 i2c_read16(register u_int16 address, register u_int16 reg );
u_int16 i2c_read16_LE(register u_int16 address, register u_int16 reg );
s_int16 i2c_readS16(register u_int16 address, register u_int16 reg );
s_int16 i2c_readS16_LE(register u_int16 address, register u_int16 reg );
u_int32 i2c_read24(register u_int16 address, register u_int16 reg );
s_int32 i2c_read24S(register u_int16 address, register u_int16 reg );
u_int32 i2c_read20_bme(register u_int16 address, register u_int16 reg );
ioresult i2c_transmitOctet(u_int16 data);
ioresult i2c_TransmitData(void *const TXdata,register u_int16 dataLen );
ioresult i2c_ReadData(void *const TXdata,register u_int16 dataLenSend, register u_int16 bytesToRead);



void I2CStart() {
	GpioSetAsInput(I2C_SDA); // floating state = pullup 1
	GpioSetPin(I2C_SCL, 1);
	GpioSetAsInput(I2C_SCL); // pullup sck 1
	GpioSetPin(I2C_SDA, 0);     // drive SDA to GND -> start condition
	GpioSetPin(I2C_SCL, 0);     // clock -> 0, data may change now
	DelayL(122); //~10us
}


void I2CStop() {
	
	GpioSetPin(I2C_SCL, 0);
	GpioSetPin(I2C_SDA, 0);     //  data -> 0
	GpioSetPin(I2C_SCL, 1);
	GpioSetAsInput(I2C_SCL); // pullup sck 1
	GpioSetAsInput(I2C_SDA); // floating state = pullup 1, data up - STOP condition
	DelayL(122); //~10us
}


void i2c_write8( u_int16 address, u_int16 reg,  u_int16 value) {
		//u_int16 data[3]={address,reg,value};
	u_int16 data[3];
	data[0]=address;
	data[1]=reg;
	data[2]=value;
	i2c_TransmitData(data,3);
}


u_int16 i2c_read8(register u_int16 address, register u_int16 reg ) {
	
	//u_int16 data[2]={address,reg};
	u_int16 data[2];
	data[0]=address;
	data[1]=reg;
	
	i2c_ReadData(data, 2, 1);
	return i2cReceiveBuffer[0];
}

u_int16 i2c_read16(register u_int16 address, register u_int16 reg ) {
	
	//u_int16 data[2]={address,reg};
	u_int16 data[2];
	data[0]=address;
	data[1]=reg;
	
	i2c_ReadData(data, 2, 2);
	return (i2cReceiveBuffer[1] | i2cReceiveBuffer[0]<<8);
}


u_int16 i2c_read16_LE(register u_int16 address, register u_int16 reg ) {
	u_int16 data[2];
	data[0]=address;
	data[1]=reg;
	
	i2c_ReadData(data, 2, 2);
	return (i2cReceiveBuffer[0] | i2cReceiveBuffer[1]<<8);

}

s_int16 i2c_readS16(register u_int16 address, register u_int16 reg ) {
		//u_int16 data[2]={address,reg};
	u_int16 data[2];
	data[0]=address;
	data[1]=reg;
	
	i2c_ReadData(data, 2, 2);
	return (s_int16)(i2cReceiveBuffer[1] | i2cReceiveBuffer[0]<<8);
	
}

s_int16 i2c_readS16_LE(register u_int16 address, register u_int16 reg ) {
	u_int16 data[2];
	data[0]=address;
	data[1]=reg;
	
	i2c_ReadData(data, 2, 2);
	return (s_int16)(i2cReceiveBuffer[0] | i2cReceiveBuffer[1]<<8);
}

u_int32 i2c_read20_bme(register u_int16 address, register u_int16 reg ) {
	u_int16 data[2];
	data[0]=address;
	data[1]=reg;
	
	i2c_ReadData(data, 2, 3);
	return (u_int32)(i2cReceiveBuffer[2]>>4 | (i2cReceiveBuffer[1]<<4) | (((u_int32)i2cReceiveBuffer[0])<<12));
}

u_int32 i2c_read24(register u_int16 address, register u_int16 reg ) {
	u_int16 data[2];
	data[0]=address;
	data[1]=reg;
	
	i2c_ReadData(data, 2, 3);
	return (u_int32)(i2cReceiveBuffer[2] | (i2cReceiveBuffer[1]<<8) | (((u_int32)i2cReceiveBuffer[0])<<16));

}

s_int32 i2c_read24S(register u_int16 address, register u_int16 reg ) {
	u_int16 data[2];
	data[0]=address;
	data[1]=reg;
	
	i2c_ReadData(data, 2, 3);
	
	return (s_int32)(i2cReceiveBuffer[2] | (i2cReceiveBuffer[1]<<8) | (((u_int32)i2cReceiveBuffer[0])<<16));

}



ioresult i2c_transmitOctet(u_int16 data) {
	u_int16 i, b;
	for (i = 0; i < 8; i++) {
		if (data & (1 << 7)) {
			GpioSetPin(I2C_SDA, 1);
			GpioSetAsInput(I2C_SDA); // floating state = pullup 1
		} else {
			GpioSetPin(I2C_SDA, 0);
		}
		GpioSetPin(I2C_SCL, 1);
		GpioSetAsInput(I2C_SCL); // pullup sck
		// Quite fast clock ...
		data <<= 1;
		GpioSetPin(I2C_SCL, 0);
	}
	//byte has been send, now check for ACK		
	GpioSetAsInput(I2C_SDA); // floating state = pullup 1	
	GpioSetAsInput(I2C_SCL); // pullup sck 1
	for(b = 0; b < I2C_ACK_TIMEOUT; b++) {     // wait ack
		if (!GpioReadInputPin(I2C_SDA)) {  // fast read, pin already in input mode
			GpioSetPin(I2C_SDA, 0); // pull SDA to 0 to prevent a glitch when SCK goes up and slave releases SDA
			break;  // wait for data -> 0 =  ACK
		}
	}
	GpioSetPin(I2C_SCL, 0);
	if (b == I2C_ACK_TIMEOUT) return S_ERROR; // ack timeout -> 0 bytes (reliably) sent
	return S_OK;
}



ioresult i2c_TransmitData(void *const TXdata,register u_int16 dataLen ) {
	u_int16 i,j,b;
	u_int16 *data = (u_int16 *)TXdata;
	
	//copy data to output buffer
	for (i = 0; i < dataLen; i++){
		i2cTransmitBuffer[i] = data[i];
	}
	
	I2CStart();

	for (j = 0; j < dataLen; j++){
	
		if (i2c_transmitOctet(i2cTransmitBuffer[j])) {
			//printf("i2c NACK\n");
			b++;
		}
		
		
	}
	I2CStop();
	
	if (b){ 
		return S_ERROR; // ack timeout -> 0 bytes (reliably) sent
	}
	
	return S_OK;
	
}

ioresult i2c_ReadData(void *const TXdata,register u_int16 dataLenSend, register u_int16 bytesToRead){
	u_int16 i,j,b;
	u_int16 inData;
	u_int16 *data = (u_int16 *)TXdata;
	
	i2cReceiveBuffer[2]=0x00;
	i2cReceiveBuffer[1]=0x00;
	i2cReceiveBuffer[0]=0x00;

	
	//copy data to output buffer
	memcpy(i2cTransmitBuffer, data, dataLenSend);
	/*for (i = 0; i < dataLenSend; i++){
		i2cTransmitBuffer[i] = data[i];
	}*/
	I2CStart();
	
	for (i = 0; i <= 1; i++){
		if(i==1){

			//might need a wait here
			I2CStart(); //restart condition
			i2cTransmitBuffer[0]|=0x01; //read
			dataLenSend=1;
		}
		
		for (j = 0; j < dataLenSend; j++){
			if (i2c_transmitOctet(i2cTransmitBuffer[j])) {
				//printf("i2c NACK\n");
				b++;
			}
			
		}
	
	}
	

	i=0;
	for (j = 0; j < bytesToRead; j++){
		inData=0;	
		GpioSetAsInput(I2C_SDA);
		DelayL(122); //~10us
		for(b = 0; b < 8; b++) {
			GpioSetPin(I2C_SCL, 0);
			DelayL(3); 
			//GpioSetAsInput(I2C_SCL);
			GpioSetPin(I2C_SCL, 1);
			DelayL(3); 
			inData <<= 1;
			inData |= GpioReadInputPin(I2C_SDA); // ReadInput pin return 1 or 0 
		}
		i2cReceiveBuffer[i++]=inData;
		
		//byte has been send, now check for ACK, except on last byte		
		GpioSetAsInput(I2C_SDA); // floating state = pullup 1	
		DelayL(10); 

		if(j < (bytesToRead-1)){
			//master sends ACK
			GpioSetPin(I2C_SCL, 0);
			DelayL(10);  
			GpioSetPin(I2C_SDA, 0);
			DelayL(3); 
			GpioSetPin(I2C_SCL, 1);
			DelayL(3);
			GpioSetPin(I2C_SCL, 0);	
			DelayL(3);
			GpioSetAsInput(I2C_SDA);
			DelayL(122); //~10us
			
		}else{
			// NACK 
			GpioSetPin(I2C_SCL, 0);	
			DelayL(3); 
			GpioSetPin(I2C_SCL, 1);
			DelayL(122); //~10us
		}
	}
	I2CStop();
	
	
	if (b == I2C_ACK_TIMEOUT) return S_ERROR; // ack timeout -> 0 bytes (reliably) sent
	return S_OK;
	
}






