#ifndef NOISEGATE_H
#define NOISEGATE_H
#include <vstypes.h>
// Audio stream dependent variable
extern u_int16 wordsPerSample;

// Setup variables
extern u_int16 noisegateDBThreshold;
extern u_int16 noisegateAttackUs;
extern u_int16 noisegateHoldMs;
extern u_int16 noisegateReleaseMs;

// Setup function
void NoisegateSetParameters(register u_int16 thresholdDb,
                            register u_int16 attackUs,
                            register u_int16 holdMs,
                            register u_int16 releaseMs);

// Signal processing function.
void NoisegateProcess(register s_int16 *p, register u_int16 samples);

// Helper functions to convert db to linear
auto u_int16 DBToLin(u_int16 n);
#endif
