/* For free support for VSIDE, please visit www.vsdsp-forum.com */

// From solution noisegate file: main.c

// Starting point template for creating VSOS3 libraries and device drivers.
// This will create a <projectname>.DL3 file, which you can copy to 
// your VS1005 Developer Board's system disk's SYS subdirectory.

// If init(), main() or fini() are not needed, remove them from the solution.
// There's no need to have any unneeded functions in the library.

#include <vo_stdio.h>
#include <volink.h>     // Linker directives like DLLENTRY
#include <apploader.h>  // RunLibraryFunction etc
#include <string.h>
#include <stdlib.h>
#include <vo_gpio.h>
#include <aucommon.h>
#include "noisegate.h"

FILE *inOrg = NULL;
u_int16 wordsPerSample = 1;
extern FILEOPS noisegateOp;
extern SIMPLE_FILE noisegate;

// This function is called when the library is loaded.
// If CONFIG.TXT has several instance of the same driver,
// init() is called only once.
void init(void) {
  // Copy not implemented functions from stdaudioin.
  inOrg = stdaudioin;
  noisegate.flags = stdaudioin->flags;
  noisegateOp.Open = stdaudioin->op->Open;
  noisegateOp.Close = stdaudioin->op->Close;
  noisegateOp.Write = stdaudioin->op->Write;
  // Set stdaudioin pointing to noisegate.
  stdaudioin = (VO_FILE *)&noisegate;
}

char* NoisegateIdentify(register __i0 void *self,
                        char *buf,
                        u_int16 bufsize) {
  return "Noise Gate";
}

IOCTL_RESULT NoisegateIoctl (register __i0 VO_FILE *self,
                             s_int16 request,
                             IOCTL_ARGUMENT arg) {
  IOCTL_RESULT ret;                           

  //Pass IOCTL request to the original stdaudioin
  ret = inOrg->op->Ioctl(inOrg, request, arg);
  // If call touched bits, read them back
  // to get current values.
  if (request == IOCTL_AUDIO_SET_RATE_AND_BITS ||
      request == IOCTL_AUDIO_SET_BITS          ||
      request == IOCTL_AUDIO_SET_IRATE) {
    NoisegateSetParameters(noisegateDBThreshold,
                           noisegateAttackUs,
                           noisegateHoldMs,
                           noisegateReleaseMs);
  }
  // Return original value.
  return ret;
}

u_int16 NoisegateRead (register __i0 VO_FILE *self,
                       void *buf,
                       u_int16 destinationIndex,
                       u_int16 bytes) {
  /* If this read function was something else than audio,
     read and mute should be implemented in a way which
     could handle the odd destinationIndex and any number
     of bytes.

     In case of audio, the read must be stereo pair of samples.
     16-bit: bytes %4 == 0 32-bit bytes % 8 == 0
  */
#if 0 
  static s_int16 tmpBuf[128];
  u_int16 b = bytes;
  // This way odd destinationIndex won't break muting.
  while (bytes) {
    if (b > 256) {
      b = 256;
    }
    inOrg->op->Read(inOrg, tmpBuf, 0, b);

    if (GpioReadPin(0x00)) { // Button S1 pressed
      memset(tmpBuf, 0, sizeof(tmpBuf));
    } else {
      NoisegateProcess(tmpBuf, b/(2*wordsPerSample));
    }
    MemCopyPackedBigEndian(buf, destinationIndex, (u_int16*)tmpBuf, 0, b);
    destinationIndex += b;
    bytes -= b;
  }
#else
  inOrg->op->Read(inOrg, buf, destinationIndex, bytes);	
  if (GpioReadPin(0x00)) { // Button S1 pressed
    memset(buf + destinationIndex, 0, (bytes>>1));
  } else {
    NoisegateProcess(buf + destinationIndex, bytes/(2*wordsPerSample));
  }
#endif
}

// Startup code for each instance of the library
// If CONFIG.TXT has several instance of the same driver,
// this is called for each line.
ioresult main(char *parameters) {
  int nParam, i;
  u_int16 *nextValue = NULL;
  char *p = parameters;
  ioresult ret = S_OK;
  nParam = RunLibraryFunction("ParamSpl", ENTRY_MAIN, (u_int16)parameters);
  for(i = 0; i < nParam; i++){
    if(!strcmp(p, "-h")){
      printf("Usage: noisegate [-p|-t lim|-a usec |-w msec|-r msec|-h]\n"
             "-p\tPrint the threshold level, attack, hold and release times.\n"
             "-t\tSet threshold limit dB.\n"
             "lim\tThreshold limit in decibels\n"
             "-a\tSet attack time.\n"
             "usec\tMicrosecond (10^-6 s)"
             "-w\tSet hold time.\n"
             "msec\tMillisecond (10^-3 s)\n"
             "-r\tSet release time.\n"
             "-h\tShow this help\n"
             "If no parameters are given, default threshold value is set.\n"
             "Timing isn't changed\n");
      goto finally;
    } else if (!strcmp(p, "-p")){
      printf("Noisegate threshold: %02u dB, att: %03u us, hold: %03u ms, "
             "rel: %03u ms\n", noisegateDBThreshold, noisegateAttackUs,
             noisegateHoldMs,noisegateReleaseMs);
      goto finally;
    } else if (!strcmp(p, "-t")){
      nextValue = &noisegateDBThreshold;
    } else if (!strcmp(p, "-a")){
      nextValue = &noisegateAttackUs;
    } else if (!strcmp(p, "-w")){
      nextValue = &noisegateHoldMs;
    } else if (!strcmp(p, "-r")){
      nextValue = &noisegateReleaseMs;
    } else if(nextValue){
      char *tmp;
      s_int32 val = strtol(p, &tmp, 0);
      if (*tmp == '\0'){
        if (nextValue == &noisegateDBThreshold){
          if(val < 0){
            val = 96 + val;
          }
          if(val > 96){
            goto bad_value;
          }
          *nextValue = (u_int16)val;
          nextValue = NULL;
        } else {
          if ( val >= 0 && val < 65536){
            *nextValue = (u_int16)val;
            nextValue = NULL;
          } else {
            goto bad_value;
          }
        }
      } else {
        goto bad_value;
      }
    } else {
      printf("E: Unknown parameter \"%s\"", p);
      ret = S_ERROR;
      goto finally;
    }
    p += strlen(p) +1;
  }
  if(!nParam){
    // Default threshold (noisegate disabled)
    noisegateDBThreshold = 0;
  }
  NoisegateSetParameters(noisegateDBThreshold,
                         noisegateAttackUs,
                         noisegateHoldMs,
                         noisegateReleaseMs);
finally:
  return ret;
bad_value:
  printf("E: Bad value \"%s\"", p);
  ret = S_ERROR;
  return ret;
}

// Library finalization code.
// This is called when the library is dropped from memory,
// (reference count drops to zero due to a call to DropLibrary)
void fini(void) {
  // Set stdaudioin back to its original state.
  stdaudioin = inOrg;
}

//temporarily switch off compile warning about different objects
#pragma msg 30 off
FILEOPS noisegateOp = {
  CommonOkResultFunction, //AudioOpen, 
  CommonOkResultFunction, //AudioClose, 
  NoisegateIoctl, 
  NoisegateRead,//Not real AudioRead 
  CommonOkResultFunction, //AudioWrite
};
#pragma msg 30 on


SIMPLE_FILE noisegate = {
  0, // flags: not present 
  NoisegateIdentify, // Identify() function
  &noisegateOp, // Fileoperations from above.
};
