/* For free support for VSIDE, please visit www.vsdsp-forum.com */

// From solution noisegate file: main.c

// Starting point template for creating VSOS3 libraries and device drivers.
// This will create a <projectname>.DL3 file, which you can copy to 
// your VS1005 Developer Board's system disk's SYS subdirectory.

// If init(), main() or fini() are not needed, remove them from the solution.
// There's no need to have any unneeded functions in the library.

#include <vo_stdio.h>
#include <volink.h>     // Linker directives like DLLENTRY
#include <apploader.h>  // RunLibraryFunction etc
#include <string.h>
#include <stdlib.h>
#include <vo_gpio.h>
#include <aucommon.h>


FILE *inOrg = NULL;
u_int16 wordsPerSample = 1;
extern FILEOPS noisegateOp;
extern SIMPLE_FILE noisegate;

// This function is called when the library is loaded.
// If CONFIG.TXT has several instance of the same driver,
// init() is called only once.
void init(void) {
  // Copy not implemented functions from stdaudioin.
  inOrg = stdaudioin;
  noisegate.flags = stdaudioin->flags;
  noisegateOp.Open = stdaudioin->op->Open;
  noisegateOp.Close = stdaudioin->op->Close;
  noisegateOp.Write = stdaudioin->op->Write;
  // Set stdaudioin pointing to noisegate.
  stdaudioin = (VO_FILE *)&noisegate;
}

char* NoisegateIdentify(register __i0 void *self,
                        char *buf,
                        u_int16 bufsize) {
  return "Noise Gate";
}

IOCTL_RESULT NoisegateIoctl (register __i0 VO_FILE *self,
                             s_int16 request,
                             IOCTL_ARGUMENT arg) {
  IOCTL_RESULT ret;                           

  //Pass IOCTL request to the original stdaudioin
  ret = inOrg->op->Ioctl(inOrg, request, arg);
  // If call touched bits, read them back
  // to get current values.
  if (request == IOCTL_AUDIO_SET_RATE_AND_BITS ||
      request == IOCTL_AUDIO_SET_BITS          ||
      request == IOCTL_AUDIO_SET_IRATE) {
    wordsPerSample = inOrg->op->Ioctl(inOrg, IOCTL_AUDIO_GET_BITS, NULL)>>4;
  }
  // Return original value.
  return ret;
}

u_int16 NoisegateRead (register __i0 VO_FILE *self,
                       void *buf,
                       u_int16 destinationIndex,
                       u_int16 bytes) {
  /* If this read function was something else than audio,
     read and mute should be implemented in a way which
     could handle the odd destinationIndex and any number
     of bytes.

     In case of audio, the read must be stereo pair of samples.
     16-bit: bytes %4 == 0 32-bit bytes % 8 == 0
  */
#if 0 
  static s_int16 tmpBuf[128];
  u_int16 b = bytes;
  // This way odd destinationIndex won't break muting.
  while (bytes) {
    if (b > 256) {
      b = 256;
    }
    inOrg->op->Read(inOrg, tmpBuf, 0, b);

    if (GpioReadPin(0x00)) { // Button S1 pressed
      memset(tmpBuf, 0, sizeof(tmpBuf));
    }
    MemCopyPackedBigEndian(buf, destinationIndex, (u_int16*)tmpBuf, 0, b);
    destinationIndex += b;
    bytes -= b;
  }
#else
  inOrg->op->Read(inOrg, buf, destinationIndex, bytes);	
  if (GpioReadPin(0x00)) { // Button S1 pressed
      memset(buf + destinationIndex, 0, (bytes>>1));
  }
#endif
}

// Startup code for each instance of the library
// If CONFIG.TXT has several instance of the same driver,
// this is called for each line.
ioresult main(char *parameters) {
}

// Library finalization code.
// This is called when the library is dropped from memory,
// (reference count drops to zero due to a call to DropLibrary)
void fini(void) {
  // Set stdaudioin back to its original state.
  stdaudioin = inOrg;
}

//temporarily switch off compile warning about different objects
#pragma msg 30 off
FILEOPS noisegateOp = {
  CommonOkResultFunction, //AudioOpen, 
  CommonOkResultFunction, //AudioClose, 
  NoisegateIoctl, 
  NoisegateRead,//Not real AudioRead 
  CommonOkResultFunction, //AudioWrite
};
#pragma msg 30 on


SIMPLE_FILE noisegate = {
  0, // flags: not present 
  NoisegateIdentify, // Identify() function
  &noisegateOp, // Fileoperations from above.
};
